<?php
session_start();
error_reporting(0);
include 'includes/config.php';
if (strlen($_SESSION['alogin']) == "") {
    header("Location: index.php");
} else {

    ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Manage Results</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" media="screen">
    <link rel="stylesheet" href="css/font-awesome.min.css" media="screen">
    <link rel="stylesheet" href="css/animate-css/animate.min.css" media="screen">
    <link rel="stylesheet" href="css/lobipanel/lobipanel.min.css" media="screen">
    <link rel="stylesheet" href="css/prism/prism.css" media="screen"> <!-- USED FOR DEMO HELP - YOU CAN REMOVE IT -->
    <link rel="stylesheet" type="text/css" href="js/DataTables/datatables.min.css" />
    <link rel="stylesheet" href="css/main.css" media="screen">
	
	
	 <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

	
    <script src="js/modernizr/modernizr.min.js"></script>
    <style>
        .errorWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #dd3d36;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }

        .succWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #5cb85c;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }
    </style>
</head>

<body class="top-navbar-fixed">
    <div class="main-wrapper">

        <!-- ========== TOP NAVBAR ========== -->
        <?php include 'includes/topbar.php';?>
        <!-- ========== WRAPPER FOR BOTH SIDEBARS & MAIN CONTENT ========== -->
        <div class="content-wrapper">
            <div class="content-container">
                <?php include 'includes/leftbar.php';?>

                <div class="main-page">
                    <div class="container-fluid">
                        <div class="row page-title-div">
                            <div class="col-md-6">
                                <h2 class="title">Manage Results</h2>

                            </div>

                            <!-- /.col-md-6 text-right -->
                        </div>
                        <!-- /.row -->
                        <div class="row breadcrumb-div">
                            <div class="col-md-6">
                                <ul class="breadcrumb">
                                    <li><a href="dashboard.php"><i class="fa fa-home"></i> Home</a></li>
                                    <li> Students</li>
                                    <li class="active">Manage Students</li>
                                </ul>
                            </div>

                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.container-fluid -->

                    <section class="section">
                        <div class="container-fluid">



                            <div class="row">
                                <div class="col-md-12">

                                    <div class="panel">
                                        <div class="panel-heading">
                                            <div class="panel-title">
                                                <h5>View Students Info</h5>
                                            </div>
                                        </div>
                                        <?php if ($msg) {?>
                                        <div class="alert alert-success left-icon-alert" role="alert">
                                            <strong>Well done!</strong><?php echo htmlentities($msg); ?>
                                        </div><?php } else if ($error) {?>
                                        <div class="alert alert-danger left-icon-alert" role="alert">
                                            <strong>Oh snap!</strong> <?php echo htmlentities($error); ?>
                                        </div>
                                        <?php }?>
                                        <div class="panel-body p-20" style="display:none">

                                            <table id="example" class="display table table-striped table-bordered"
                                                cellspacing="0" width="100%">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Student Name</th>
                                                        <th>Roll Id</th>
                                                        <th>Class</th>
                                                        <th>Subject</th>
                                                        <th>Marks</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tfoot>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Student Name</th>
                                                        <th>Roll Id</th>
                                                        <th>Class</th>
														<th>Subject</th>
                                                        <th>Marks</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </tfoot>
                                                <tbody>
                                                    <?php 
													$sql="";
													$query='';
													if(isset($_GET['professorid'])){
													

													$sql = "SELECT tblstudents.StudentName, tblstudents.StudentId, tblsubjects.SubjectName, tblstudents.RollId, tblstudents.ClassId, tblclasses.ClassName, tblresult.marks FROM tblresult JOIN tblstudents ON tblstudents.StudentId = tblresult.StudentId JOIN tblclasses ON tblstudents.ClassId = tblclasses.id JOIN tblsubjectcombination ON tblsubjectcombination.ClassId = tblclasses.id AND tblsubjectcombination.SubjectId = tblresult.SubjectId JOIN tblsubjects ON tblsubjects.id = tblsubjectcombination.SubjectId WHERE tblsubjectcombination.ProfessorId = :p ORDER BY tblstudents.StudentName, tblsubjects.SubjectName";
													 $query = $dbh->prepare($sql);	
														$query->bindParam(':p', $_GET['professorid'], PDO::PARAM_STR);
													}else{
													
													$sql = "SELECT tblstudents.StudentName,  tblstudents.StudentId, tblsubjects.SubjectName, tblstudents.RollId, tblstudents.ClassId, tblclasses.ClassName, tblresult.marks, tblsubjectcombination.credit FROM tblresult JOIN tblstudents ON tblstudents.StudentId = tblresult.StudentId JOIN tblclasses ON tblstudents.ClassId = tblclasses.id JOIN tblsubjectcombination ON tblsubjectcombination.ClassId = tblclasses.id AND tblsubjectcombination.SubjectId = tblresult.SubjectId JOIN tblsubjects ON tblsubjects.id = tblsubjectcombination.SubjectId WHERE tblsubjectcombination.ClassId = :p ORDER BY tblstudents.StudentName, tblsubjects.SubjectName";
													 $query = $dbh->prepare($sql);
													 $query->bindParam(':p', $_GET['classid'], PDO::PARAM_STR);
													}
													  
                                                        $query->execute();
                                                        $results = $query->fetchAll(PDO::FETCH_OBJ);
                                                        $cnt = 1;
                                                        if ($query->rowCount() > 0) {
                                                            foreach ($results as $result) {
                                                    ?>
                                                    <tr>
                                                        <td><?php echo htmlentities($cnt); ?></td>
                                                        <td><?php echo htmlentities($result->StudentName); ?></td>
                                                        <td><?php echo htmlentities($result->RollId); ?></td>
                                                        <td><?php echo htmlentities($result->ClassName); ?>
                                                        <td><?php echo htmlentities($result->SubjectName); ?>
                                                        </td>
                                                        <td><?php echo htmlentities($result->marks); ?></td>
                                                        <td>
                                                            <a
                                                                href="edit-result.php?stid=<?php echo htmlentities($result->StudentId); ?>"><i
                                                                    class="fa fa-edit" title="Edit Record"></i> </a>

                                                        </td>
                                                    </tr>
                                                    <?php $cnt = $cnt + 1;}}?>


                                                </tbody>
                                            </table>
                                            </div>
											
											<div class="panel-body p-20">
											
		<?php	

$query2 = $dbh->prepare("SELECT DISTINCT tblclasses.id, tblclasses.ClassName FROM tblclasses JOIN tblstudents ON tblstudents.ClassId = tblclasses.id JOIN tblsubjectcombination ON tblsubjectcombination.ClassId = tblclasses.id WHERE tblsubjectcombination.ProfessorId = :p ORDER BY tblclasses.ClassName");
	$query2->bindParam(':p', $_GET['professorid'], PDO::PARAM_STR);
	$query2->execute();
    $results2 = $query2->fetchAll(PDO::FETCH_OBJ);

$classes = [];
foreach ($results2 as $row) {
    $classes[$row->id] = $row->ClassName;
}		
											
$students = [];
$subjects = [];
$studentClasses = [];



// Organisation des données
$query->execute();
$results = $query->fetchAll(PDO::FETCH_OBJ);
foreach ($results as $row) {
    //$studentKey = $row->StudentName. " (ID: " . $row->RollId . ")";
    $studentKey = $row->StudentName;
    $subject = $row->SubjectName;
    $subjects[$subject] = true;
   
	$students[$studentKey]['marks'][$subject] = $row->marks;
	 $students[$studentKey]['credits'][$subject] = $row->credit;
    $students[$studentKey]['class'] = $row->ClassName;
}

$subjects = array_keys($subjects);
function getMention($average) {
    if ($average < 8) return "Échec grave (Ajourné)";
    if ($average < 10) return "Ajourné";
    if ($average < 12) return "Passable";
    if ($average < 14) return "Assez bien";
    if ($average < 16) return "Bien";
    if ($average < 18) return "Très bien";
    return "Excellent";
}
// Affichage du tableau HTML

// Fermeture de la connexion

?>

<div class="filter-container">
    <label for="classFilter">Filtrer par classe : </label>
    <select id="classFilter">
        <option value="">Toutes les classes</option>
        <?php foreach ($classes as $id => $className): ?>
            <option value="<?= htmlspecialchars($className) ?>"><?= htmlspecialchars($className) ?></option>
        <?php endforeach; ?>
    </select>
</div>


<table id="gradesTable" class="display" style="width:100%">
    <thead>
        <tr>
            <th>Élève</th>
            <?php foreach ($subjects as $subject): ?>
                <th><?= htmlspecialchars($subject) ?> <br>
				 <?= htmlspecialchars($subject->credit) ?>
				</th>
            <?php endforeach; ?>
            <th>Échecs légers</th>
            <th>Échecs graves</th>
            <th>Moyenne</th>
			<th>Crédits validés</th>
            <th>Crédits non validés</th>
            <th>Mention</th>
            <th class="hidden">Classe</th>
        </tr>
		
    </thead>
    <tbody>
         <?php foreach ($students as $studentName => $data): 
            $marks = $data['marks'];
            $credits = $data['credits'];
            $sum = 0; $count = 0; 
            $failsLight = 0; $failsSevere = 0;
            $creditValid = 0; $creditInvalid = 0;

            foreach ($marks as $subject => $m) {
                $c = $credits[$subject];
                $sum += $m; $count++;
                if ($m >= 10) {
                    $creditValid += $c;
                } else {
                    $creditInvalid += $c;
                }
                if ($m >= 8 && $m < 10) $failsLight++;
                if ($m < 8) $failsSevere++;
            }

            $average = $count > 0 ? round($sum / $count, 2) : 0;
            $mention = getMention($average);
        ?>
            <tr>
                <td><?= htmlspecialchars($studentName) ?></td>
                <?php foreach ($subjects as $subject): ?>
                    <td style="text-align:center">
                        <?= isset($marks[$subject]) ? htmlspecialchars($marks[$subject]) : "-" ?>
                    </td>
                <?php endforeach; ?>
                <td STYLE="background:#e8e8ff" style="text-align:center"><?= $failsLight ?></td>
                <td  STYLE="background:#e8e8ff"style="text-align:center"><?= $failsSevere ?></td>
                <td STYLE="background:#e8e8ff" style="text-align:center"><?= $average ?></td>
                <td STYLE="background:#e8e8ff" style="text-align:center"><?= $creditValid ?></td>
                <td  STYLE="background:#e8e8ff"style="text-align:center"><?= $creditInvalid ?></td>
                <td STYLE="background:#e8e8ff"><?= $mention ?></td>
                <td class="hidden" STYLE="background:#e8e8ff"><?= htmlspecialchars($data['class']) ?></td>
         
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>


<script>
var table = $('#gradesTable').DataTable({
    "language": {
        "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json"
    },
    "paging": true,
    "searching": true,
    "ordering": true,
    "columnDefs": [
        { "targets": -1, "visible": false } // Colonne "Classe" (dernière)
    ]
});

// Calcule dynamiquement l'index de la colonne "Classe"
var classColumnIndex = $('#gradesTable thead th').length - 1;

// Filtrage par classe
$('#classFilter').on('change', function () {
    var selectedClass = $(this).val();
    table.column(classColumnIndex).search(selectedClass).draw();
});
</script>

<style>
    .hidden {
        display: none;
    }
</style>



                                            <!-- /.col-md-12 -->
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-md-6 -->


                            </div>
                            <!-- /.col-md-12 -->
                        </div>
                </div>
                <!-- /.panel -->
            </div>
            <!-- /.col-md-6 -->

        </div>
        <!-- /.row -->

    </div>
    <!-- /.container-fluid -->
    </section>
    <!-- /.section -->

    </div>
    <!-- /.main-page -->



    </div>
    <!-- /.content-container -->
    </div>
    <!-- /.content-wrapper -->

    </div>
    <!-- /.main-wrapper -->

    <!-- ========== COMMON JS FILES ========== -->
    <script src="js/jquery/jquery-2.2.4.min.js"></script>
    <script src="js/bootstrap/bootstrap.min.js"></script>
    <script src="js/pace/pace.min.js"></script>
    <script src="js/lobipanel/lobipanel.min.js"></script>
    <script src="js/iscroll/iscroll.js"></script>

    <!-- ========== PAGE JS FILES ========== -->
    <script src="js/prism/prism.js"></script>
    <script src="js/DataTables/datatables.min.js"></script>

    <!-- ========== THEME JS ========== -->
    <script src="js/main.js"></script>
    <script>
        $(function ($) {
            $('#example').DataTable();

            $('#example2').DataTable({
                "scrollY": "300px",
                "scrollCollapse": true,
                "paging": false
            });

            $('#example3').DataTable();
        });
    </script>
</body>

</html>
<?php }?>